IF EXISTS (select * from sysobjects where name like '%T_Delete_WM_ServidorCliente%')
DROP TRIGGER T_Delete_WM_ServidorCliente
go

CREATE TRIGGER T_Delete_WM_ServidorCliente
ON  WM_ServidorCliente
FOR DELETE
AS
	DECLARE @IdZona DECIMAL(20,0);

	DECLARE Elems_Cursor_Delete_WMSC CURSOR FOR
	SELECT IsNull(IdZona,-1) FROM DELETED;
	OPEN Elems_Cursor_Delete_WMSC

	FETCH NEXT FROM Elems_Cursor_Delete_WMSC INTO @IdZona
	WHILE @@FETCH_STATUS = 0
	BEGIN	

		IF @IdZona != -1
		BEGIN
			--En caso de que el servidor tenga zona vinculada, hacemos la proteccin que la zona sea zona final
			IF (SELECT COUNT(*) FROM WM_Zona WHERE WM_Zona.IdZonaPadre=@IdZona) = 0
			BEGIN
				IF (SELECT COUNT(*) FROM WM_ServidorCliente WHERE IsNull(IdZona,-1)=@IdZona) > 0
				BEGIN
					UPDATE WM_Zona SET TieneServidores=1 WHERE WM_Zona.IdZona=@IdZona
				END
				ELSE
				BEGIN
					UPDATE WM_Zona SET TieneServidores=0 WHERE WM_Zona.IdZona=@IdZona
				END
			END
		END

		PRINT 'Ejecucion trigger T_Delete_WM_ServidorCliente.'
		
	FETCH NEXT FROM Elems_Cursor_Delete_WMSC INTO @IdZona
	END

	CLOSE Elems_Cursor_Delete_WMSC
	DEALLOCATE Elems_Cursor_Delete_WMSC
	
GO
ALTER TABLE WM_ServidorCliente ENABLE TRIGGER T_Delete_WM_ServidorCliente
GO
